<?php

class Ultimate_AI_Payments_Module
{
  public $payment_data, $UAI_SUBSCRIPTION, $UAI_STRIPE, $UAI_PAYPAL;
  public function __construct()
  {
    // UltimateAI register webhooks
    add_action('rest_api_init', [$this, 'ultimate_ai_webhooks']);
  }

  public function gateway_active($method_id)
  {
    $payment_methods = get_option('ultimate_ai_payment_method', []);
    if (isset($payment_methods) && !empty($payment_methods)) {
      // return true;
      if (isset($payment_methods[$method_id]['is_active'])) {
        if ($payment_methods[$method_id]['is_active'] == 'false') {
          return false;
        } else {
          return true;
        }
      } else {
        if (!isset($payment_methods[$method_id]['api_key']) || empty($payment_methods[$method_id]['api_key'])) {
          return false;
        } elseif (!isset($payment_methods[$method_id]['api_secret']) || empty($payment_methods[$method_id]['api_secret'])) {
          return false;
        } elseif (!isset($payment_methods[$method_id]['gateway']) || empty($payment_methods[$method_id]['gateway'])) {
          return false;
        } else {
          return true;
        }
      }
    } else {
      return false;
    }
  }
  public function active_payment_methods()
  {
    $methods = $this->payment_methods();

    if (empty($methods)) {
      return [
        'status' => 401,
        'message' => esc_html__('No active payment processor found.', ULTIMATE_AI_SLUG),
        'error_code' => 'EMPTY_PAYMENT_METHODS'
      ];
    }

    $active_methods = [];

    foreach ((array)$methods as $key => $value) {
      if ($value['is_active'] == 'true') {
        $active_methods[] = $key;
      }
    }
    return apply_filters('uai_active_payment_methods', $active_methods);
  }
  public function securedCheckout()
  {
    $payment_method = $this->payment_data['payment_method'];

    switch ($payment_method) {
      case 'stripe':
        $this->UAI_STRIPE = new Ultimate_AI_Stripe();
        return $this->UAI_STRIPE->create_checkout($this->payment_data);
        break;

      case 'paypal':
        $this->UAI_PAYPAL = new Ultimate_AI_Paypal();
        return $this->UAI_PAYPAL->create_checkout($this->payment_data);
        break;

      case 'woocommerce':
        $this->UAI_WOOCOMMERCE = new Ultimate_AI_WooCommerce();
        return $this->UAI_WOOCOMMERCE->create_checkout($this->payment_data);
        break;
    }
  }
  public function setPaymentdata($id)
  {
    return $this->payment_data = $id;
  }
  public function payment_methods()
  {
    return get_option('ultimate_ai_payment_method', []);
  }

  public function calculate_price($OrgPrice, $discount, $discount_method)
  {
    $final_price = 0;

    if ((int) $discount > 0 && !empty($discount)) {
      switch ($discount_method) {
        case 'pct':
          $discounted = ((int) $OrgPrice * (int) $discount) / 100;
          $final_price = (int) $OrgPrice - $discounted;
          break;
        case 'currency':
          $final_price = (int) $OrgPrice - $discount;
          break;
      }

      return (int) $final_price;
    } else {
      return (int) $OrgPrice;
    }
  }

  public function ultimate_ai_webhooks()
  {
    register_rest_route(
      'webhooks/v1',
      '/stripe/',
      array(
        'methods'  => 'POST',
        'callback' => [$this, 'ultimate_ai_webhook_stripe'],
        'permission_callback' => '__return_true'
      )
    );
    register_rest_route(
      'webhooks/v1',
      '/paypal/',
      array(
        'methods'  => 'POST',
        'callback' => [$this, 'ultimate_ai_webhook_paypal'],
        'permission_callback' => '__return_true'
      )
    );
  }
  public function ultimate_ai_webhook_stripe(WP_REST_Request $req)
  {
    $body = $req->get_body();
    $event_response = json_decode($body);

    $subscription = new Ultimate_AI_Subscription();

    $res = $subscription->processSubscriptonWebhook('stripe', $event_response);
    return $res;
  }
  public function ultimate_ai_webhook_paypal(WP_REST_Request $req)
  {
    $body = $req->get_body();
    $event_response = json_decode($body);

    $subscription = new Ultimate_AI_Subscription();

    $res = $subscription->processSubscriptonWebhook('paypal', $event_response);
    return $res;
  }

  public function createSuccessUrl($gateway, $pricing_id, $order_id = '')
  {
    switch ($gateway) {
      case 'paypal':
        return add_query_arg(
          array(
            'payment_via' => 'paypal',
            'pricing_id' => $pricing_id,
          ),
          $this->getDashboardUrl('success')
        );
        break;
      case 'stripe':
        return add_query_arg(
          array(
            'pricing_id' => $pricing_id,
            'session_id' => '{CHECKOUT_SESSION_ID}',
            'payment_via' => 'stripe'
          ),
          $this->getDashboardUrl('success')
        );
        break;
      case 'woocommerce':
        return add_query_arg(
          array(
            'pricing_id' => $pricing_id,
            'order_id' => $order_id,
            'payment_via' => 'woocommerce'
          ),
          $this->getDashboardUrl('success')
        );
        break;
    }
  }

  public function getDashboardUrl($path = '')
  {
    $dashboard_page_id = get_option('ultimate_ai_dashboard_page_id');
    return get_the_permalink($dashboard_page_id) . '/' . $path;
  }

  public function prepareSuccessResponse($args)
  {
    $UAI_SUBSCRIPTION = new Ultimate_AI_Subscription();
    $UAI_PAYPAL = new Ultimate_AI_Paypal();

    $via = $args['payment_via'];
    $pricing_id = $args['pricing_id'];

    if ($via == 'stripe') {
      $UAI_STRIPE = new Ultimate_AI_Stripe();
      $order_data = $UAI_STRIPE->CreateOrderData($args['session_id'], $pricing_id);
    }

    if ($via == 'woocommerce') {
      $order_id = $args['order_id'];
      $order = wc_get_order($order_id);


      $UAI_WOO = new Ultimate_AI_WooCommerce();
      $order_data = $UAI_WOO->CreateOrderData($order, $pricing_id);
    }

    if ($via == 'paypal') {
      $token = ($args['token']);

      if (isset($args['subscription_id'])) {
        $order_details = $UAI_PAYPAL->subscription_details($args['subscription_id']);
        $order_data = $UAI_PAYPAL->CreateOrderData($order_details, $pricing_id);
      } else {
        $order_details = $UAI_PAYPAL->order_details($token);
        if ($order_details->status == 'APPROVED') {
          $captured_order = $UAI_PAYPAL->capture_order($token);
          $order_data = $UAI_PAYPAL->CreateOrderData($captured_order, $pricing_id);
        } else {
          $order_data = $UAI_PAYPAL->CreateOrderData($order_details, $pricing_id);
        }
      }
    }

    $subscribed = $UAI_SUBSCRIPTION->subscribe($order_data);

    return $subscribed;
  }

  public function updateGatewaySubscriptionStatus($gateway, $status, $subscription_id)
  {
    switch (strtolower($gateway)) {
      case 'paypal':
        $UAI_PAYPAL = new Ultimate_AI_Paypal();
        switch ($status) {
          case 'CANCEL':
            return $UAI_PAYPAL->cancelSubscription($subscription_id);
            break;
        }
        break;

      case 'stripe':
        $UAI_STRIPE = new Ultimate_AI_Stripe();
        switch ($status) {
          case 'CANCEL':
            return $UAI_STRIPE->cancelSubscription($subscription_id);
            break;
        }
        break;
    }
  }
}

